/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.container;

import com.mojang.datafixers.util.Pair;
import dev.toma.gunsrpg.common.container.AbstractModContainer;
import dev.toma.gunsrpg.common.container.CrystalStationContainer;
import dev.toma.gunsrpg.common.init.ModContainers;
import dev.toma.gunsrpg.common.init.ModTags;
import dev.toma.gunsrpg.common.item.perk.PerkVariant;
import dev.toma.gunsrpg.common.tileentity.CrystalPurificationStationTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class CrystalPurificationStationContainer
extends AbstractModContainer<CrystalPurificationStationTileEntity> {
    public CrystalPurificationStationContainer(int windowId, PlayerInventory inventory, CrystalPurificationStationTileEntity tile) {
        super((ContainerType)ModContainers.CRYSTAL_PURIFICATION.get(), windowId, inventory, tile);
        IItemHandlerModifiable handler = tile.getItemHandler();
        this.func_75146_a((Slot)new OutputSlot((IItemHandler)handler, 0, 71, 52));
        this.func_75146_a((Slot)new VariantRestrictedSlot((IItemHandler)handler, 1, 71, 10, (ITag<Item>)ModTags.Items.CRYSTAL, CrystalStationContainer.EMPTY_CRYSTAL_SLOT));
        for (int y = 0; y < 3; ++y) {
            this.func_75146_a((Slot)new VariantRestrictedSlot((IItemHandler)handler, 2 + y, 102, 13 + y * 18, (ITag<Item>)ModTags.Items.ORB_OF_PURITY, CrystalStationContainer.EMPTY_PURITY_SLOT));
        }
        this.addPlayerInventory(inventory, 82);
    }

    public CrystalPurificationStationContainer(int windowId, PlayerInventory inventory, PacketBuffer buffer) {
        this(windowId, inventory, (CrystalPurificationStationTileEntity)((Object)CrystalPurificationStationContainer.readTileEntity(buffer, inventory)));
    }

    private static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int func_75219_a() {
            return 1;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return false;
        }
    }

    private class VariantRestrictedSlot
    extends SlotItemHandler {
        private final ITag<Item> requiredItem;
        private final ResourceLocation location;

        public VariantRestrictedSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, ITag<Item> requiredItem, ResourceLocation location) {
            super(itemHandler, index, xPosition, yPosition);
            this.requiredItem = requiredItem;
            this.location = location;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            if (!stack.func_77973_b().func_206844_a(this.requiredItem)) {
                return false;
            }
            CrystalPurificationStationTileEntity tile = (CrystalPurificationStationTileEntity)CrystalPurificationStationContainer.this.tileEntity;
            PerkVariant variant = tile.getItemVariant(stack);
            PerkVariant target = tile.getTargetedPerkVariant();
            return target == null || variant == target;
        }

        public int func_75219_a() {
            return 1;
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)this.location);
        }
    }
}

